--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNgantryParams ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobj
  local LOCsignPath  = ""
  local LOCundoState = on
  local LOCspinStartValue
  local LOCiniArraysUpdateRequired = true
  local LOCresourceKitMode   = 1

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNvspGantryFilter     FUNobj = ((classof FUNobj.baseObject == VSP_Gantry) or (classof FUNobj.baseObject == VSP_GantryNL) or (classof FUNobj.baseObject == VSP_GantryNZ) or (classof FUNobj.baseObject == VSP_GantrySA))

  fn DYNFUNgantryParams FUNobj =
  (
    FUNobj.baseObject.height             = FUNobj.baseObject.height
    DYNgantryParams.LOCobj               = FUNobj
    DYNgantryParams.SPDYNlength.value    = FUNobj.baseObject.length
    DYNgantryParams.SPDYNheight.value    = FUNobj.baseObject.height
    DYNgantryParams.SPDYNxfall.value     = FUNobj.baseObject.xfall

    --- Display Gantry Style Related Information in Panel
    try (DYNgantryParams.CKDYNlStyle.checked  = FUNobj.baseObject.lStyle) catch (DYNgantryParams.CKDYNlStyle.enabled = false)
    if (classof $.baseObject) == VSP_Gantry or (classof $.baseObject) == VSP_GantryNL then DYNgantryParams.RBDYNstyle.state    = 1
    if (classof $.baseObject) == VSP_GantryNZ then DYNgantryParams.RBDYNstyle.state = 2
    if (classof $.baseObject) == VSP_GantrySA then DYNgantryParams.RBDYNstyle.state = 3
    DYNgantryParams.CKDYNlStyle.enabled = true
    try (DYNgantryParams.CKDYNlStyle.checked = FUNobj.baseObject.lStyle) catch (DYNgantryParams.CKDYNlStyle.enabled = false)

    --- For Dutch Gantry Only - Display Signals Settings
    if ((classof $.baseObject) != VSP_Gantry and (classof $.baseObject) != VSP_GantryNL) or (try (FUNobj.baseObject.signals) catch ()) == undefined then
    (
      DYNgantryParams.CKDYNflip.checked    = false
      DYNgantryParams.CKDYNsignals.checked = false
      DYNgantryParams.SPDYNnumber.range    = [0,0,0]
      DYNgantryParams.SPDYNgap.range       = [0.0,0.0,0.0]
      DYNgantryParams.SPDYNoffset.range    = [0.0,0.0,0.0]
      DYNgantryParams.CKDYNflip.enabled    = false
      DYNgantryParams.SPDYNnumber.enabled  = false
      DYNgantryParams.SPDYNgap.enabled     = false
      DYNgantryParams.SPDYNoffset.enabled  = false
      DYNgantryParams.CKDYNsignals.enabled = false
      DYNgantryParams.BUDYNotherTypes.enabled = false
      DYNgantryParams.BUDYNnoSign.enabled = false
    )
    else
    (
      DYNgantryParams.CKDYNflip.checked    = FUNobj.baseObject.flipSignals
      DYNgantryParams.CKDYNsignals.checked = FUNobj.baseObject.signals
      DYNgantryParams.SPDYNnumber.range    = [1,12,FUNobj.baseObject.numberOfSignals]
      DYNgantryParams.SPDYNgap.range       = [2,100,FUNobj.baseObject.SignalGap]
      DYNgantryParams.SPDYNoffset.range    = [0,100,FUNobj.baseObject.SignalOffset]

      if FUNobj.baseObject.signals then
      (
        DYNgantryParams.CKDYNsignals.enabled = true
        DYNgantryParams.CKDYNflip.enabled    = true
        DYNgantryParams.SPDYNnumber.enabled  = true
        DYNgantryParams.SPDYNgap.enabled     = true
        DYNgantryParams.SPDYNoffset.enabled  = true

        --- Create A Temporary Array Of Sign Object INI Files From Current DVSP Country Kit Folders
        local LOCsignArray = DYNFUNgetfiles DYNgantryParams.LOCsignPath 1 "*.ini"
        DYNgantryParams.BUDYNotherTypes.enabled = if classOf FUNobj.material == Multimaterial and LOCsignArray.count > 0 then true else false
        DYNgantryParams.BUDYNnoSign.enabled = if classOf FUNobj.material == Multimaterial and LOCsignArray.count > 0 then true else false
      )
      else
      (
        DYNgantryParams.CKDYNsignals.enabled = true
        DYNgantryParams.CKDYNflip.enabled    = false
        DYNgantryParams.SPDYNnumber.enabled  = false
        DYNgantryParams.SPDYNgap.enabled     = false
        DYNgantryParams.SPDYNoffset.enabled  = false
        DYNgantryParams.BUDYNotherTypes.enabled = false
        DYNgantryParams.BUDYNnoSign.enabled = false
      )
    )

    --- For Non-Dutch Gantries - Set up Radius Params
    if ((classof $.baseObject) != VSP_GantryNZ and (classof $.baseObject) != VSP_GantrySA) or (try (FUNobj.baseObject.radius) catch ()) == undefined then
    (
      DYNgantryParams.SPDYNradius.enabled = false
      DYNgantryParams.SPDYNdia.enabled    = false
      DYNgantryParams.SPDYNradius.range   = [0.0,0.0,0.0]
      DYNgantryParams.SPDYNdia.range      = [0.0,0.0,0.0]
    )
    else
    (
      DYNgantryParams.SPDYNradius.enabled = true
      DYNgantryParams.SPDYNdia.enabled    = true
      DYNgantryParams.SPDYNradius.range   = [0.1,10.0,FUNobj.baseObject.radius]
      DYNgantryParams.SPDYNdia.range      = [0.1,2.0,FUNobj.baseObject.dia]
    )

    --- Get current Material
    local LOCmatArray = DYNFUNgetMatChannelNames FUNobj.material true true DYNINImatIDlimit
    if LOCmatArray.count > 10 then (for i = LOCmatArray.count to 11 by -1 do deleteItem LOCmatArray i)
    DYNgantryParams.DDDYNtype.items      = LOCmatArray
    if LOCmatArray.count > 0 then
    (
      local LOCmatID = if (FUNobj.baseObject.matID) > DYNgantryParams.DDDYNtype.items.count then DYNgantryParams.DDDYNtype.items.count else (FUNobj.baseObject.matID)
      FUNobj.baseObject.matID = LOCmatID
      DYNgantryParams.DDDYNtype.selection  = FUNobj.baseObject.matID
      DYNgantryParams.DDDYNtype.enabled    = true
    )
    else DYNgantryParams.DDDYNtype.enabled = false

    --- Check whether other instances exist
    DYNFUNgatherInstancesOfNode DYNgantryParams FUNobj
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  groupbox GBDYN01 width:(DYNiniExplorerWidth - 21) height:47 pos:[4,7]
  dropdownlist DDDYNtype pos:[13,26] width:(DYNiniExplorerWidth - 39)

  groupbox GBDYN02 width:(DYNiniExplorerWidth - 21) height:60 pos:[4,59]
  radioButtons RBDYNstyle labels:#(DYNuiResourcesLabels[237], DYNuiResourcesLabels[238], DYNuiResourcesLabels[239]) columns:3 pos:[13,78] width:(DYNiniExplorerWidth - 39)
  checkbox CKDYNlStyle pos:[13,98] width:(DYNiniExplorerWidth - 39)

  groupbox GBDYN03 width:(DYNiniExplorerWidth - 21) height:83 pos:[4,124]
  label LBDYNlength pos:[13,143] width:(DYNiniExplorerWidth - 108)
  label LBDYNheight pos:[13,164] width:(DYNiniExplorerWidth - 108)
  label LBDYNxfall  pos:[13,185] width:(DYNiniExplorerWidth - 108)
  spinner SPDYNlength fieldwidth:60 type:#worldunits range:[3.0,1000.0,0]   scale:1.0   pos:[(DYNiniExplorerWidth - 96),143]
  spinner SPDYNheight fieldwidth:60 type:#worldunits range:[3.0,1000.0,0]               pos:[(DYNiniExplorerWidth - 96),164]
  spinner SPDYNxfall  fieldwidth:60 type:#float      range:[-0.1,0.050,0.0] scale:0.025 pos:[(DYNiniExplorerWidth - 96),185]

  groupbox GBDYN04 width:(DYNiniExplorerWidth - 21) height:62 pos:[4,212]
  label LBDYNradius pos:[13,231] width:(DYNiniExplorerWidth - 108)
  label LBDYNdia    pos:[13,252] width:(DYNiniExplorerWidth - 108)
  spinner SPDYNradius "" fieldwidth:60 type:#worldunits range:[0.0,0.0,0.0] scale:0.05 pos:[(DYNiniExplorerWidth - 96),231]
  spinner SPDYNdia    "" fieldwidth:60 type:#worldunits range:[0.0,0.0,0.0] scale:0.01 pos:[(DYNiniExplorerWidth - 96),252]

  groupbox GBDYN05 width:(DYNiniExplorerWidth - 21) height:129 pos:[4,279]
  checkbox CKDYNsignals width:85 pos:[13,298]
  checkbox CKDYNflip    width:85 pos:[100,298]
  label LBDYNnumber  pos:[13,318] width:(DYNiniExplorerWidth - 108)
  label LBDYNgap     pos:[13,339] width:(DYNiniExplorerWidth - 108)
  label LBDYNoffset  pos:[13,360] width:(DYNiniExplorerWidth - 108)
  spinner  SPDYNnumber  "" fieldwidth:60 type:#integer    range:[0,0,0]            pos:[(DYNiniExplorerWidth - 96),318]
  spinner  SPDYNgap     "" fieldwidth:60 type:#worldunits range:[0,0,0] scale:0.01 pos:[(DYNiniExplorerWidth - 96),339]
  spinner  SPDYNoffset  "" fieldwidth:60 type:#worldunits range:[0,0,0] scale:0.01 pos:[(DYNiniExplorerWidth - 96),360]

  button BUDYNotherTypes width:(DYNiniExplorerWidth - 63) pos:[13,381]
  button BUDYNnoSign width:20 pos:[(DYNiniExplorerWidth - 46),381]

  groupbox GBDYN06 width:(DYNiniExplorerWidth - 21) height:72 pos:[4,413]
  checkbutton CBDYNlinked width:(DYNiniExplorerWidth - 39) highlightColor:DYNINIhighlightColor pos:[13,432]
  pickbutton PKDYNlink    width:(DYNiniExplorerWidth - 39) highlightColor:DYNINIhighlightColor filter:DYNFUNvspGantryFilter pos:[13,458]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNgantryParams open do
  (
    DYNgantryParams.title  = DYNuiRolloutNames[25]

    GBDYN01.text           = DYNuiResourcesGroups[72]
    GBDYN02.text           = DYNuiResourcesGroups[73]
    GBDYN03.text           = DYNuiResourcesGroups[74]
    GBDYN04.text           = DYNuiResourcesGroups[75]
    GBDYN05.text           = DYNuiResourcesGroups[76]
    GBDYN06.text           = DYNuiResourcesGroups[1]

    CKDYNflip.text         = DYNuiResourcesLabels[240]
    CKDYNlStyle.text       = DYNuiResourcesLabels[241]
    LBDYNdia.text          = DYNuiResourcesLabels[242]
    LBDYNnumber.text       = DYNuiResourcesLabels[243]
    LBDYNgap.text          = DYNuiResourcesLabels[244]
    LBDYNoffset.text       = DYNuiResourcesLabels[245]
    LBDYNradius.text       = DYNuiResourcesLabels[233]
    LBDYNlength.text       = DYNuiResourcesLabels[28]
    LBDYNheight.text       = DYNuiResourcesLabels[30]
    LBDYNxfall.text        = DYNuiResourcesLabels[11]

    LOCsignPath            = DYNcountryPath + DYNfolderNameObjLibs + "\\" + DYNfolderNameSigns + "\\"

    CKDYNsignals.text      = DYNuiResourcesLabels[22]
    PKDYNlink.text         = DYNuiResourcesButtons[24]
    BUDYNotherTypes.text   = DYNuiResourcesButtons[58]
    BUDYNnoSign.text       = DYNuiResourcesButtons[22]
  )

  on DYNgantryParams close do
  (
    LOCobj = undefined
  )

  --- Length Spinner
  on SPDYNlength changed arg do (with undo label:(DYNuiResourcesUndoLabels[14]) LOCundoState LOCobj.baseObject.length = arg)
  on SPDYNlength buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNlength.value)
  on SPDYNlength buttonUp    do
  (
    if LOCspinStartValue != SPDYNlength.value then
    (
      with undo off LOCobj.baseObject.length = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[14]) on LOCobj.baseObject.length = SPDYNlength.value
    )
    LOCundoState    = on
  )

  --- Height Spinner
  on SPDYNheight changed arg do (with undo label:(DYNuiResourcesUndoLabels[14]) LOCundoState LOCobj.baseObject.height = arg)
  on SPDYNheight buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNheight.value)
  on SPDYNheight buttonUp    do
  (
    if LOCspinStartValue != SPDYNheight.value then
    (
      with undo off LOCobj.baseObject.height = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[14]) on LOCobj.baseObject.height = SPDYNheight.value
    )
    LOCundoState    = on
  )

  --- CrossFall Spinner
  on SPDYNxfall changed arg do (with undo label:(DYNuiResourcesUndoLabels[14]) LOCundoState LOCobj.baseObject.xfall = arg)
  on SPDYNxfall buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNxfall.value)
  on SPDYNxfall buttonUp    do
  (
    if LOCspinStartValue != SPDYNxfall.value then
    (
      with undo off LOCobj.baseObject.xfall = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[14]) on LOCobj.baseObject.xfall = SPDYNxfall.value
    )
    LOCundoState    = on
  )

  --- NZ Radius Diameter Spinner
  on SPDYNradius changed arg do (with undo label:(DYNuiResourcesUndoLabels[14]) LOCundoState LOCobj.baseObject.radius = arg)
  on SPDYNradius buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNradius.value)
  on SPDYNradius buttonUp    do
  (
    if LOCspinStartValue != SPDYNradius.value then
    (
      with undo off LOCobj.baseObject.radius = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[14]) on LOCobj.baseObject.radius = SPDYNradius.value
    )
    LOCundoState    = on
  )

  --- NZ Tube Diameter Spinner
  on SPDYNdia changed arg do (with undo label:(DYNuiResourcesUndoLabels[14]) LOCundoState LOCobj.baseObject.dia = arg)
  on SPDYNdia buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNdia.value)
  on SPDYNdia buttonUp    do
  (
    if LOCspinStartValue != SPDYNdia.value then
    (
      with undo off LOCobj.baseObject.dia = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[14]) on LOCobj.baseObject.dia = SPDYNdia.value
    )
    LOCundoState    = on
  )

  --- Signal Number Spinner
  on SPDYNnumber changed arg do (with undo label:(DYNuiResourcesUndoLabels[14]) LOCundoState LOCobj.baseObject.numberOfSignals = arg)
  on SPDYNnumber buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNnumber.value)
  on SPDYNnumber buttonUp    do
  (
    if LOCspinStartValue != SPDYNnumber.value then
    (
      with undo off LOCobj.baseObject.numberOfSignals = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[14]) on LOCobj.baseObject.numberOfSignals = SPDYNnumber.value
    )
    LOCundoState    = on
  )

  --- Gap Spinner
  on SPDYNgap changed arg do (with undo label:(DYNuiResourcesUndoLabels[14]) LOCundoState LOCobj.baseObject.SignalGap = arg)
  on SPDYNgap buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNgap.value)
  on SPDYNgap buttonUp    do
  (
    if LOCspinStartValue != SPDYNgap.value then
    (
      with undo off LOCobj.baseObject.SignalGap = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[14]) on LOCobj.baseObject.SignalGap = SPDYNgap.value
    )
    LOCundoState    = on
  )

  --- Signal Offset Spinner
  on SPDYNoffset changed arg do (with undo label:(DYNuiResourcesUndoLabels[14]) LOCundoState LOCobj.baseObject.SignalOffset = arg)
  on SPDYNoffset buttonDown  do (LOCundoState = off; LOCspinStartValue = SPDYNoffset.value)
  on SPDYNoffset buttonUp    do
  (
    if LOCspinStartValue != SPDYNoffset.value then
    (
      with undo off LOCobj.baseObject.SignalOffset = LOCspinStartValue
      with undo label:(DYNuiResourcesUndoLabels[14]) on LOCobj.baseObject.SignalOffset = SPDYNoffset.value
    )
    LOCundoState    = on
  )

  on CKDYNlStyle  changed arg do try (LOCobj.baseObject.lStyle = arg) catch ()

  on CKDYNflip    changed arg do LOCobj.baseObject.flipSignals = arg

  on CKDYNsignals changed arg do
  (
    undo off
    (
      LOCobj.baseObject.signals = arg
      if arg then
      (
        CKDYNflip.enabled       = true
        SPDYNnumber.enabled     = true
        SPDYNgap.enabled        = true
        SPDYNoffset.enabled     = true

        local LOCsignArray = DYNFUNgetfiles LOCsignPath 1 "*.ini"
        BUDYNotherTypes.enabled = if classOf LOCobj.material == Multimaterial and LOCsignArray.count > 0 then true else false
        BUDYNnoSign.enabled     = if classOf LOCobj.material == Multimaterial and LOCsignArray.count > 0 then true else false
      )
      else
      (
        CKDYNflip.enabled       = false
        SPDYNnumber.enabled     = false
        SPDYNgap.enabled        = false
        SPDYNoffset.enabled     = false
        BUDYNotherTypes.enabled = false
        BUDYNnoSign.enabled     = false
      )
    )
  )

  on DDDYNtype selected arg do
  (
    undo off
    (
      LOCobj.baseObject.matID  = arg
    )
  )

  on RBDYNstyle changed arg do
  (
    --- Collect standard gantry params from existing object
    local LOCparamArray    = #(); LOCparamArray[12] = undefined
    try (LOCparamArray[1]  = LOCobj.length) catch ()
    try (LOCparamArray[2]  = LOCobj.height) catch ()
    try (LOCparamArray[3]  = LOCobj.radius) catch ()
    try (LOCparamArray[4]  = LOCobj.dia) catch ()
    try (LOCparamArray[5]  = LOCobj.xfall) catch ()
    try (LOCparamArray[6]  = LOCobj.matID) catch ()
    try (LOCparamArray[7]  = LOCobj.lStyle) catch ()
    try (LOCparamArray[8]  = LOCobj.signals) catch ()
    try (LOCparamArray[9]  = LOCobj.numberOfSignals) catch ()
    try (LOCparamArray[10] = LOCobj.SignalGap) catch ()
    try (LOCparamArray[11] = LOCobj.flipSignals) catch ()
    try (LOCparamArray[12] = LOCobj.SignalOffset) catch ()

    --- Change to new Gantry Type
    local LOCtempObject
    try
    (
      if arg == 1 then (LOCtempObject = VSP_Gantry())
      if arg == 2 then (LOCtempObject = VSP_GantryNZ(); if LOCparamArray[3] > 3.0 then LOCparamArray[3] = 3.0)
      if arg == 3 then (LOCtempObject = VSP_GantrySA(); if LOCparamArray[3] > 3.0 then LOCparamArray[3] = 3.0)
    )
    catch (LOCtempObject = undefined)
    if isValidNode LOCtempObject then
    (
      instanceReplace LOCobj LOCtempObject
      delete LOCtempObject
    )

    --- Ensure params of new baseObject
    try (LOCobj.baseObject.length          = LOCparamArray[1])  catch ()
    try (LOCobj.baseObject.height          = LOCparamArray[2])  catch ()
    try (LOCobj.baseObject.radius          = LOCparamArray[3])  catch ()
    try (LOCobj.baseObject.dia             = LOCparamArray[4])  catch ()
    try (LOCobj.baseObject.xfall           = LOCparamArray[5])  catch ()
    try (LOCobj.baseObject.matID           = LOCparamArray[6])  catch ()
    try (LOCobj.baseObject.lStyle          = LOCparamArray[7])  catch ()
    try (LOCobj.baseObject.signals         = LOCparamArray[8])  catch ()
    try (LOCobj.baseObject.numberOfSignals = LOCparamArray[9])  catch ()
    try (LOCobj.baseObject.SignalGap       = LOCparamArray[10]) catch ()
    try (LOCobj.baseObject.flipSignals     = LOCparamArray[11]) catch ()
    try (LOCobj.baseObject.SignalOffset    = LOCparamArray[12]) catch ()

    completeRedraw()

    --- Update this gentry parameters panel
    DYNFUNgantryParams LOCobj
  )

  on CBDYNlinked changed arg do
  (
    if arg == false then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNgantryParams LOCobj 2 false
      select LOCobj
    )
  )

  on PKDYNlink picked arg do
  (
    if arg != LOCobj then
    (
      LOCobj = DYNFUNunlinkNodeInstance DYNgantryParams LOCobj 2 true
      instanceReplace LOCobj arg
      select LOCobj
    )
  )

  on BUDYNotherTypes pressed do
  (
    --- Update Main Object INI File AX Internal Arrays
    if LOCiniArraysUpdateRequired then
    (
      DYNobjectPlacer.DYNFUNmakeINIobjFileArrays()
      LOCiniArraysUpdateRequired = false
    )

    --- Display Sign Selection List
    local LOCnewFile = DYNFUNdisplayListBoxWithMapPreview DYNgantryParams DYNuiResourcesTitlebars[19] "" 4 1 "Sign Defaults" "Style" "1"

    if LOCnewFile != "" then
    (
      local LOCexistingSignsArray = DYNFUNgetMatChannelNames LOCobj.material false false DYNINImatIDlimit
      local LOCmatID = findItem LOCexistingSignsArray LOCnewFile
      if LOCmatID == 0 then
      (
        local LOCsizeArray = DYNFUNobjectINIparams LOCnewFile 4 LOCresourceKitMode
        LOCmatID = DYNFUNaddSignMatChannel LOCobj.material LOCsizeArray false
      )
      LOCobj.radius = LOCmatID
      DYNproperties.DYNFUNupdPropertiesPanel()
    )
  )

  on BUDYNnoSign pressed do
  (
    LOCobj.radius = 3.0
  )
)

-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBTJ0HkUNQjRYABVbN4Fm9CIBXsx5IeUO+Y
-- p2dXUzo60a5uLFchpIQhrKV+1/6Fkt/hFvItosw+JQw8CipU+wcCM0oEkwVr7R7m
-- Jfg3GflbSF9Cs6KI//z/1shdDqVBr/WEdDRtnUrFaThcNakxK3tf3qoIaH0bQrVP
-- mo2IjflfpQLGuKx25s5oia8N3wJj6HpMfM0WiN81ZDyxg9CYM9YbbukfMCuAopOV
-- kk7ELV1y3jkvSCwyzX39poVAl0JUcI6779n6AtQcBqDyTU2fyDwVdtGO7uKQ1O5a
-- gxTJgQN0a4wcgI51pYBBGENKUxvoXQcvyM3hRN+4PM7Nb+vibB0b
-- -----END-SIGNATURE-----